VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "CDetalleIngreso"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Option Explicit

Public Id As Long
Public TransID As Long              ' Referencia del ingreso de caja asociado
Public Medio As String
Public Monto As Currency            ' Valor del pago
Public IdTitular As String
Public NumeroCuenta As String
Public NumeroDocumento As String
Public ClaveAutorizacion As String
Public CodigoEmisor As String
Public MontoNominal As Currency     ' Valor absoluto en moneda extranjera
Public Denominaciones As Collection ' of CDetalleDenominacion

Public Function ToString() As String
  If Medio = "EFE" Then
    ToString = "EFECTIVO " & Format(Monto, "Currency")
    Exit Function
  End If
  
Dim lMedio As New CMedioPago
  If lMedio.Load(Me.Medio) Then
    If lMedio.Atributos And MonedaExtranjera Then
      Dim TipoCambio As Double
      TipoCambio = Monto / MontoNominal
      ToString = Format(MontoNominal, "#,##0.00") & Me.Medio & " x " & Format(TipoCambio, "Currency")
      Exit Function
    End If
    ToString = Me.Medio & " " & Format(Monto, "Currency")
    Exit Function
  End If
  ToString = "MEDIO INVALIDO (" & Me.Medio & ") " & Format(Me.Monto, "Currency")
  
End Function

Public Sub LoadInstance(rs As Recordset, Optional pDest As CDetalleIngreso = Nothing)
Dim p As CDetalleIngreso
  Set p = pDest
  If p Is Nothing Then Set p = Me
  With p
    .Id = GetNumeroFromVariant(rs!Id)
    .TransID = GetNumeroFromVariant(rs!TransID)
    .Medio = GetStringFromVariant(rs!Medio)
    .Monto = GetNumeroFromVariant(rs!Monto)
    .IdTitular = GetStringFromVariant(rs!IdTitular)
    .NumeroCuenta = GetStringFromVariant(rs!NumeroCuenta)
    .NumeroDocumento = GetStringFromVariant(rs!NumeroDocumento)
    .ClaveAutorizacion = GetStringFromVariant(rs!ClaveAutorizacion)
    .CodigoEmisor = GetStringFromVariant(rs!Emisor)
    .MontoNominal = GetNumeroFromVariant(rs!MontoNominal)
  End With
  Set p.Denominaciones = New Collection
  Dim rs2 As Recordset
  Set rs2 = dbHandle.Execute("SELECT * FROM DetallesDenominacion WHERE idDetalle = " & NumeroDB(Me.Id) & " ORDER BY idDetalle")
  Do While Not rs2.EOF
    Dim pDet2 As CDetalleDenominacion
    Set pDet2 = New CDetalleDenominacion
    With pDet2
    .Id = rs2(0)
    .idDetalle = rs2(1)
    .Denominacion = rs2(2)
    .CantidadRecibida = rs2(3)
    End With
    p.Denominaciones.Add pDet2
    rs2.MoveNext
  Loop
  rs2.Close
End Sub

Public Function ExisteEmisor(istrEmisor As String) As Boolean
Dim rs As Recordset, bRetVal As Boolean

  Set rs = dbHandle.Execute("SELECT Count(*) As Q FROM DetallesIngresoCaja WHERE Medio = " & StringDB(Me.Medio) & " AND Emisor = " & StringDB(istrEmisor))
  If rs.EOF Then
    bRetVal = False
  Else
    bRetVal = (GetNumeroFromVariant(rs.Fields("Q")) <> 0)
  End If
  rs.Close
  Set rs = Nothing
  
  ExisteEmisor = bRetVal
End Function

Private Sub Class_Initialize()
  Set Me.Denominaciones = New Collection
End Sub
